import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*modelTemplateBDTScore - runs templateListParser.java to find templates with TMscore > 0.4 containing biologically relevant ligands, then calculates the binding site residues for each of those templates using  proLigContacts.java - runs ligTypeVariation_V2.java to find the binding site resiudes of the model - reads in the FunFOLD output superposition files TMsup*_all puts the coords of binding site residues for teamplate and model into hashtables and a BDT like score is calculated for the distance between binding site resiudes of the model and the template runs - BDTalign 
*/

public class modelTemplateBDTScore
{
	Vector BDTalignvect = new Vector();
	double meanBDTalign = 0;

	public modelTemplateBDTScore( String FunFOLD_directory, String templatelist,  String FunFOLD_outputfile, String top_model, String target  )
	{
		try
		{
			////System.out.println("Running modelTemplateBDTScore: " + FunFOLD_directory+templatelist);
			System.out.println("Calculating BDTalign score");
			//determines the mean TM-score for for all templates with biologically relevant ligands and a template score for the number of templates divided the number of biologically revelant templates - using to find the templates that are used in FunFOLD for the determination of binding site residues
			////System.out.println("running templateListParser");
			templateListParser tmplp = new templateListParser( FunFOLD_directory, templatelist, top_model, target );
			Vector relevantTemplateVect = (Vector)tmplp.getrelevantTemplateVect();
			////System.out.println("finished running templateListParser");
			////System.out.println("relevantTemplateVect " + relevantTemplateVect);


			int templatenumb = 0;
					
			for (int i = 0; i <relevantTemplateVect.size(); i++)
			{
				double BDTalign = 0;
				Hashtable tempbindingcoordshash = new Hashtable();
				Hashtable modelbindingcoordshash = new Hashtable();
				Vector tempresiVect = new Vector();
				Vector temptypeVect = new Vector();
				
				//to determine which template is being examined to find the correct superposition file 
				templatenumb++;
				
				//Determines what each template is 
				String template = (String)relevantTemplateVect.elementAt(i);
				////System.out.println("template "+ template);

				//finds the binding site residues of the biologically relevant templates 
				////System.out.println("running pro ligs contacts");
				proLigContacts plc = new proLigContacts( FunFOLD_directory+template+".pdb" );
				Hashtable resultshash = (Hashtable)plc.getresultshash();
				String pdbid =  template.substring( 0, template.lastIndexOf("_") );
				String bsfile = pdbid+"_bs.out";
				////System.out.println("finished running pro ligs contacts");
				////System.out.println();

				//Enumerates through the hashtable of binding site reisidue types and numbers 
				for( Enumeration enumer2 = resultshash.keys(); enumer2.hasMoreElements(); )
				{
					String results = (String)enumer2.nextElement();
					StringTokenizer resultstoks = new StringTokenizer(results, ",[]");
					////System.out.println("Enumerating .......");
					
					while(resultstoks.hasMoreTokens())
					{
						String tempresinumbtype = resultstoks.nextToken();
						StringTokenizer temptypenumbtoke = new StringTokenizer( tempresinumbtype, " " );
						//template binding site reidue numbers
						String tempresinumb = temptypenumbtoke.nextToken();
						//System.out.println("tempresinumb " + tempresinumb);
						//template binding site reidue types
						String tempresitype = temptypenumbtoke.nextToken();
						//ystem.out.println("tempresitype " + tempresitype);
						//Vector of binding site reidue numbers
						tempresiVect.add(tempresinumb);
						//Vector of binding site reidue types
						temptypeVect.add(tempresitype);
					}
				}	
				//names the superposition file which is dependant on the template under examination
				String supfile = "TM.sup"+templatenumb+"_all";

				if( ( new File( FunFOLD_directory+"/"+supfile) ).exists() )
				{
					
					////System.out.println("Reading in super position file........." );
					//Read in the superposition file containing the template and the model superposed 	
					FileReader file1 = new FileReader( FunFOLD_directory+supfile );
					BufferedReader in1 = new BufferedReader(file1);
					String line1 = in1.readLine();
					String temppdbid = "";
					
					do
					{  
						// line containing PDB info
						if(line1.startsWith("REMARK Chain 1"))
						{
							StringTokenizer linetoke = new StringTokenizer(line1, ":.");
							String remark = linetoke.nextToken();
							//PDBID of the superposed template
							String PDB = linetoke.nextToken();
							////System.out.println("PDB 123 " + PDB);
							temppdbid = PDB.substring(0, PDB.lastIndexOf("_"));
						}

						if(line1.startsWith("ATOM"))
						{
							//Makes sure that the PDBID of the superposed template in the file is the same as the PDBID of the template under analysis
							if(temppdbid.equals(pdbid))
							{
								StringTokenizer atomtoke = new StringTokenizer(line1, " ");
								String atom = atomtoke.nextToken();
								////System.out.println("atom " + atom);
								String atomnumb = atomtoke.nextToken();
								////System.out.println("atomtoke " + atomtoke);
								String CA = atomtoke.nextToken();
								////System.out.println("CA " +CA );
								String templresitype = atomtoke.nextToken();
								////System.out.println("templresitype " +templresitype );
								String templresinumb = atomtoke.nextToken();
								//System.out.println("templresinumb " + templresinumb);
								String Xcoordstemp = line1.substring(30,38).trim();
								//System.out.println("Xcoordstemp " + Xcoordstemp);
								String Ycoordstemp = line1.substring(38,46).trim();
								//System.out.println("Ycoordstemp " + Ycoordstemp);
								String Zcoordstemp = line1.substring(47,54).trim();
								//System.out.println("Zcoordstemp " + Zcoordstemp);
								
								//Iterates through the vector of template binding site residues
								for (int k = 0; k <tempresiVect.size(); k++)
								{
									String Templateresinumb = (String)tempresiVect.elementAt(k); 
									//System.out.println("Templateresinumb " + Templateresinumb);
									
									// if the line in the template superposition file contains the binsing site reisudue it puts it in a vector 
									if(templresinumb.equals(Templateresinumb))
									{
										String resi = templresinumb + " " + templresitype;
										//System.out.println("resi " + resi);
										String coords = Xcoordstemp + " " + Ycoordstemp + " " + Zcoordstemp;
										//System.out.println("coords " + coords);
										//Contains the binding site coords of the template binding site residues
										tempbindingcoordshash.put(resi, coords);
									}
								}	
							}
							
						
						}
						line1 = in1.readLine();
					}
					while(!line1.startsWith("TER"));

					//Reads through the superposition file
					while(line1.startsWith("CONECT"))
					{
						line1 = in1.readLine();
					}
					
					
					do
					{
						//Makes sure that the PDBID of the superposed template in the file the same as the PDBID of the template under analysis
						//System.out.println("temppdbid "+ temppdbid);
						
						//System.out.println("pdbid "+ pdbid);

						if(temppdbid.equals(pdbid))
						{
							if(line1.startsWith("ATOM"))
							{
								StringTokenizer atomtoke = new StringTokenizer(line1, " ");
								String atommodel = atomtoke.nextToken();
								//System.out.println("atommodel " + atommodel);
								String atomnumbmodel = atomtoke.nextToken();
								//System.out.println("atomnumbmodel " + atomnumbmodel);
								String CAmodel = atomtoke.nextToken();
								//System.out.println("CAmodel " +CAmodel );
								String modelresitype = atomtoke.nextToken();
								//System.out.println("modelresitype " + modelresitype);
								String modelresinumb = atomtoke.nextToken();
								//System.out.println("modelresinumb " +modelresinumb );
								String Xcoordsmodel = line1.substring(30,38).trim();
								//System.out.println("Xcoordsmodel " + Xcoordsmodel);
								String Ycoordsmodel = line1.substring(38,46).trim();
								//System.out.println("Ycoordsmodel " + Ycoordsmodel);
								String Zcoordstmodel = line1.substring(47,54).trim();
								//System.out.println("Zcoordstmodel " + Zcoordstmodel);
								
								// run to get binding site residues of model
								//ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_directory+FunFOLD_outputfile );

								ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_outputfile );
								Vector typeVect = (Vector)ltv2.gettypeVect();
								Vector resiVect = (Vector)ltv2.getresiVect();
								//vector containing binding site residues
								Vector bsresiVect = (Vector)ltv2.getbsresiVect();
								
								//iterating through model binding site residues vector 
								for (int j = 0; j <bsresiVect.size(); j++)
								{	
									String modelbsresinumb = (String)bsresiVect.elementAt(j);
										
									//if the number of the residue in the model line is equal to the model binding site residue
									if(modelresinumb.equals(modelbsresinumb))
									{
										String modelresi = modelbsresinumb + " " + modelresitype;
										//System.out.println("modelresi " + modelresi);
										String modelcoords1 = Xcoordsmodel + " " + Ycoordsmodel + " " + Zcoordstmodel;
										//System.out.println("modelcoords1 " + modelcoords1);
										//add in coords for model binding site residues into a hashtable 
										modelbindingcoordshash.put(modelresi , modelcoords1);
									}	
									

								}   
							}
							line1 = in1.readLine();	
						}				
					}
					while(!line1.startsWith("TER"));
					in1.close();
					
					float d = 3 ;//distance cutoff for Si score
					double totMaxSi = 0.0;
					
					for( Enumeration enumer = modelbindingcoordshash.keys(); enumer.hasMoreElements(); )
					{
						double maxSi = 0.0;
						double minDist = 0.0;
						String closest_res = "";
						String numbtype1 = (String)enumer.nextElement();
						
						
						//Enumerate through the template binding site coords hashtable 
						for( Enumeration enumer1 = tempbindingcoordshash.keys(); enumer1.hasMoreElements(); )
						{	
							StringTokenizer numbtypetoks1 = new StringTokenizer(numbtype1, " ");
							String modelnumb = numbtypetoks1.nextToken();
							String modeltype = numbtypetoks1.nextToken();
								
							String modelcoords = (String)modelbindingcoordshash.get(numbtype1);
							StringTokenizer coordstoks1 = new StringTokenizer(modelcoords, " ");
							String modelxcoords = coordstoks1.nextToken();
							float ModelXcoords = (new Float(modelxcoords)).floatValue();
							String modelycoords = coordstoks1.nextToken();
							float ModelYcoords = (new Float(modelycoords)).floatValue();
							String modelzcoords = coordstoks1.nextToken();
							float ModelZcoords = (new Float(modelzcoords)).floatValue();
							
							String numbtype = (String)enumer1.nextElement();
							StringTokenizer numbtypetoks = new StringTokenizer(numbtype, " ");
							String tempnumb = numbtypetoks.nextToken();
							String temptype = numbtypetoks.nextToken();
							
							String tempcoords = (String)tempbindingcoordshash.get(numbtype );
							StringTokenizer coordstoks = new StringTokenizer(tempcoords, " ");
							String tempxcoords = coordstoks.nextToken();
							float TempXcoords = (new Float(tempxcoords)).floatValue();
							String tempycoords = coordstoks.nextToken();
							float TempYcoords = (new Float(tempycoords)).floatValue();
							String tempzcoords = coordstoks.nextToken();
							float TempZcoords = (new Float(tempzcoords)).floatValue();
							
							//calculate the distance between residues in the modela nd the template 
							double distance = Math.sqrt( ((TempXcoords-ModelXcoords)*(TempXcoords-ModelXcoords)) + ((TempYcoords-ModelYcoords)*(TempYcoords-ModelYcoords)) + ((TempZcoords-ModelZcoords)*(TempZcoords-ModelZcoords)) );


							//System.out.println("TempXcoords "+ TempXcoords+ "ModelXcoords "+ ModelXcoords + "TempYcoords "+ TempYcoords + "ModelYcoords "+ ModelYcoords+ "TempZcoords " + TempZcoords  + "ModelZcoords "+ ModelZcoords );
							//calculate the si score 

							//System.out.println("distance "+ distance);
							double Si = 1/(1+((distance/d)*(distance/d)));
							//System.out.println("Si " + Si);
							
							if( Si > maxSi )
							{
								maxSi = Si;
							}
							
						}
						totMaxSi = totMaxSi+maxSi;
					}   
					float norm = Math.max( tempbindingcoordshash.size(), modelbindingcoordshash.size() );
					
					//System.out.println("norm " + norm);				
					//System.out.println("tempbindingcoordshash size "+ tempbindingcoordshash.size());
					//System.out.println("modelbindingcoordshash size "+ modelbindingcoordshash.size());
					//calc final BDTalign
					BDTalign = (totMaxSi/norm);
					BDTalignvect.add(BDTalign);

				}
				
			}

			int BDTalignnumb = 0;
			double totBDTalign = 0;
			
			for (int j = 0; j <BDTalignvect.size(); j++)
			{
				Double BDTALIGN = (Double)BDTalignvect.elementAt(j);
				  
				BDTalignnumb++;
				totBDTalign += BDTALIGN;
			}
			meanBDTalign = (totBDTalign/BDTalignnumb);
			
			//calculate the mean BDTalign for all of the tempaltes binding sites when compared to the model binding sites 
			System.out.println("Finished calculating BDTalign score");
			//System.out.println("BDTalign " + meanBDTalign);
		}
	
		catch( Exception e )
		{
			System.out.println( "Error executing modelTemplateBDTScore! " + e );
		}	
	}

	public double getmeanBDTalign()
	{
		return meanBDTalign;
	}

	public static void main( String args[])
	{
		modelTemplateBDTScore mtbdts = new modelTemplateBDTScore( args[0], args[1], args [2], args[3], args[4] );
		double meanBDTalign = (Double)mtbdts.getmeanBDTalign();
		System.out.println("BDTalign " + meanBDTalign);
	
	}
}
			