import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*ligTypeVariation_V2 - determines the variation of ligands in the binding site cluster and outputs a score between 1 and 0 
*/

public class ligTypeVariation_V2
{
	float numbligandtype = 0;
	Vector typeVect = new Vector();
	Vector resiVect = new Vector();
	Vector bsresiVect = new Vector();
	
	public ligTypeVariation_V2( String Fn_File )
	{
		try
		{
			//System.out.println(Fn_File); //TEMP
			FileReader file1 = new FileReader( Fn_File );
			BufferedReader buff1 = new BufferedReader(file1);
			String line1 = buff1.readLine();
			do
			{
				if( line1.startsWith( "Binding site" ))
				{
					//System.out.println("Binding site");
					StringTokenizer bindingresitoks = new StringTokenizer( line1, ":;, " );
					String binding = bindingresitoks.nextToken();
					String site = bindingresitoks.nextToken();
					
					while( bindingresitoks.hasMoreTokens())
					{
						String bsresi = bindingresitoks.nextToken();
						bsresiVect.add(bsresi);
					}
				}
				//line1 = buff1.readLine();

				//System.out.println("All ligands clustered at site"); 
				
				if( line1.contains( "All ligands clustered at site" ))
				{
					StringTokenizer ligtokens = new StringTokenizer( line1, ":;" );
					String comment = ligtokens.nextToken(); 
					String centroid = ligtokens.nextToken(); 
					
					while( ligtokens.hasMoreTokens())
					{
						
						String ligtype = ligtokens.nextToken(); 
						StringTokenizer ligtypetoke = new StringTokenizer( ligtype, ",; " );

						while( ligtypetoke.hasMoreTokens())
						{
							numbligandtype++;
							String ligTpNum1 = ligtypetoke.nextToken(); 
							StringTokenizer ligtypeNumb = new StringTokenizer( ligTpNum1, "- " );
							String lig = ligtypeNumb.nextToken(); 
							//System.out.println("Ligand " + numbligandtype + ": " + lig);
							String Numb = ligtypeNumb.nextToken();
							float NUMB = (new Float(Numb)).floatValue();
							typeVect.addElement(NUMB);
							resiVect.addElement(lig);
							
						}
						
						float sum = 0;
						float numbofligs = 0;
						float linenumb = 0;
						
						for (int i = 0; i <typeVect.size(); i++)
						{
							sum += (Float)typeVect.elementAt(i);
						}
						float total = sum;
						
						for (int i = 0; i <typeVect.size(); i++)
						{
							linenumb++;
							numbofligs = (Float)typeVect.elementAt(i);
							float ligs = (numbofligs/total);
 							//System.out.println("Ligand diversity " + linenumb + ": " + ligs);
						}

						//System.out.println("Total number of ligands: " + total);  //TEMP
						//System.out.println("Number of ligand types: " + numbligandtype); // TEMP
						
						float typediversity = (1-(numbligandtype / total));
						//System.out.println("Variation in ligand type: " + typediversity);//TEMP
				
					}
					
				}
				line1 = buff1.readLine();
				
				if( line1.contains( "No binding sites predicted" ))
				{
					//System.out.println("Variation in ligand type: NaN");
					//System.out.println("No binding sites predicted"); //TEMP
				}
				
			}
			while( !line1.startsWith("END"));
			buff1.close();
			
		}
	
		catch( Exception e )
		{
			System.out.println( "Error executing ligTypeVariation_V2!" + e );
		}	
	}
	
	public Vector gettypeVect()
	{
		return typeVect;
	}
	
	public Vector getresiVect()
	{
		return resiVect;
	}
	
	public Vector getbsresiVect()
	{
		return bsresiVect;
	}
	
	public static void main( String args[])
	{
		ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( args[0] );
		Vector typeVect = (Vector)ltv2.gettypeVect();
		Vector resiVect = (Vector)ltv2.getresiVect();
		Vector bsresiVect = (Vector)ltv2.getbsresiVect();
		//System.out.println("bsresiVect: "+ bsresiVect);
	}
}
			