import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*equivalentResidueTypeAnalysis - runs templateListParser.java to find templates with TMscore > 0.4 containing biologically relevant ligands, then calculates the binding site residues for each of those templates using  proLigContacts.java - runs ligTypeVariation_V2.java to find the binding site resiudes of the model - reads in the FunFOLD output superposition files TMsup*_all puts the coords of binding site residues for teamplate and model in to hashtables and the nearset structurally equilavent model binding site residues in the templates are found then the equilavent residues are analyses using BLOSUM62 
*/

public class equivalentResidueTypeAnalysis
{
	Vector equiResiVect = new Vector();
	Vector equiBlossVect = new Vector();
	float meanequiresiscore = 0;
	float meanequiblossscore = 0;
	float normalizedmeanequiblossscore = 0;
	Hashtable resiAhash = new Hashtable();
	Hashtable resiRhash = new Hashtable();
	Hashtable resiNhash = new Hashtable();
	Hashtable resiDhash = new Hashtable();
	Hashtable resiChash = new Hashtable();
	
	Hashtable resiQhash = new Hashtable();
	Hashtable resiEhash = new Hashtable();
	Hashtable resiGhash = new Hashtable();
	Hashtable resiHhash = new Hashtable();
	Hashtable resiIhash = new Hashtable();
	
	Hashtable resiLhash = new Hashtable();
	Hashtable resiKhash = new Hashtable();
	Hashtable resiMhash = new Hashtable();
	Hashtable resiFhash = new Hashtable();
	Hashtable resiPhash = new Hashtable();
	
	Hashtable resiShash = new Hashtable();
	Hashtable resiThash = new Hashtable();
	Hashtable resiWhash = new Hashtable();
	Hashtable resiYhash = new Hashtable();
	Hashtable resiVhash = new Hashtable();
	
	Hashtable resiBhash = new Hashtable();
	Hashtable resiJhash = new Hashtable();
	Hashtable resiZhash = new Hashtable();
	Hashtable resiXhash = new Hashtable();
	Hashtable resi_hash = new Hashtable();
	
	public equivalentResidueTypeAnalysis( String FunFOLD_directory, String templatelist,  String FunFOLD_outputfile, String top_model, String target )
	{
		try
		{
			
			//Read in the BLOSUM62 matrix 
			//System.out.println("Running equivalentResidueTypeAnalysis: " + FunFOLD_directory+FunFOLD_outputfile);
			System.out.println("Calculating Identity and Rescaled BLOSUM62 scores");
			
			InputStream is2 = equivalentResidueTypeAnalysis.class.getResourceAsStream("/BLOSUM62.dat");
			BufferedReader blossbuff = new BufferedReader(new InputStreamReader(is2));

			//System.out.println("reading BLOSUM62");
//FileReader blossreader = new FileReader( "/BLOSUM62" );
			//BufferedReader blossbuff  = new BufferedReader(blossreader);
			String blossline = blossbuff.readLine();

				
			do 
			{
				if(blossline.startsWith("#"))
				{
					blossline = blossbuff.readLine();
				}
				
				//puts the BLOSUM62 matrix into hashtables for each residues against all of the other residues
				if(!blossline.startsWith("#") && !blossline.startsWith("   "))
				{
					StringTokenizer blosumtoks = new StringTokenizer(blossline, " ");
					String resi = blosumtoks.nextToken();
					String resiA = blosumtoks.nextToken();
					resiAhash.put(resi ,resiA);
					String resiR = blosumtoks.nextToken();
					resiRhash.put(resi ,resiR);
					String resiN = blosumtoks.nextToken();
					resiNhash.put(resi ,resiN);
					String resiD = blosumtoks.nextToken();
					resiDhash.put(resi ,resiD);
					String resiC = blosumtoks.nextToken();
					resiChash.put(resi ,resiC);
					String resiQ = blosumtoks.nextToken();
					resiQhash.put(resi ,resiQ);
					String resiE = blosumtoks.nextToken();
					resiEhash.put(resi ,resiE);
					String resiG = blosumtoks.nextToken();
					resiGhash.put(resi ,resiG);
					String resiH = blosumtoks.nextToken();
					resiHhash.put(resi ,resiH);
					String resiI = blosumtoks.nextToken();
					resiIhash.put(resi ,resiI);
					String resiL = blosumtoks.nextToken();
					resiLhash.put(resi ,resiL);
					String resiK = blosumtoks.nextToken();
					resiKhash.put(resi ,resiK);
					String resiM = blosumtoks.nextToken();
					resiMhash.put(resi ,resiM);
					String resiF = blosumtoks.nextToken();
					resiFhash.put(resi ,resiF);
					String resiP = blosumtoks.nextToken();
					resiPhash.put(resi ,resiP);
					String resiS = blosumtoks.nextToken();
					resiShash.put(resi ,resiS);
					String resiT = blosumtoks.nextToken();
					resiThash.put(resi ,resiT);
					String resiW = blosumtoks.nextToken();
					resiWhash.put(resi ,resiW);
					String resiY = blosumtoks.nextToken();
					resiYhash.put(resi ,resiY);
					String resiV = blosumtoks.nextToken();
					resiVhash.put(resi ,resiV);
					String resiB = blosumtoks.nextToken();
					resiBhash.put(resi ,resiB);
					String resiJ = blosumtoks.nextToken();
					resiJhash.put(resi ,resiJ);
					String resiZ = blosumtoks.nextToken();
					resiZhash.put(resi ,resiZ);
					String resiX = blosumtoks.nextToken();
					resiXhash.put(resi ,resiX);
					String resi_ = blosumtoks.nextToken();
					resi_hash.put(resi ,resi_);
					
				}	
				blossline = blossbuff.readLine();				
			}
			while(blossline != null);

			//System.out.println("finished reading BLOSUM62");
			
			templateListParser tmplp = new templateListParser( FunFOLD_directory, templatelist, top_model, target );

			Vector relevantTemplateVect = (Vector)tmplp.getrelevantTemplateVect();
			
			int templatenumb = 0;
			
			for (int i = 0; i <relevantTemplateVect.size(); i++)
			{
				Hashtable tempbindingcoordshash = new Hashtable();
				Hashtable modelbindingcoordshash = new Hashtable();
				Vector tempresiVect = new Vector();
				Vector temptypeVect = new Vector();
				
				//to determine which template is being examined to find the correct superposition file 
				templatenumb++;
				
				//Determines what each template is 
				String template = (String)relevantTemplateVect.elementAt(i);
				
				//finds the binding site residues of the biologically relevant templates 
				proLigContacts plc = new proLigContacts( FunFOLD_directory+template+".pdb" );
				Hashtable resultshash = (Hashtable)plc.getresultshash();
				String pdbid =  template.substring( 0, template.lastIndexOf("_") );
				String bsfile = pdbid+"_bs.out";
				
				//Enumerates through the hashtable of binding site reisidue types and numbers 
				for( Enumeration enumer2 = resultshash.keys(); enumer2.hasMoreElements(); )
				{
					String results = (String)enumer2.nextElement();
					StringTokenizer resultstoks = new StringTokenizer(results, ",[]");
					
					while(resultstoks.hasMoreTokens())
					{
						String tempresinumbtype = resultstoks.nextToken();
						StringTokenizer temptypenumbtoke = new StringTokenizer( tempresinumbtype, " " );
						String tempresinumb = temptypenumbtoke.nextToken();
						String tempresitype = temptypenumbtoke.nextToken();
						tempresiVect.add(tempresinumb);
						temptypeVect.add(tempresitype);
					}
				}	
				//names the superposition file which is dependant on the template under examination
				String supfile = "TM.sup"+templatenumb+"_all";
				
				if( ( new File( FunFOLD_directory+"/"+supfile) ).exists() )
				{

					//Read in the superposition file containing the template and the model superposed 
					FileReader file1 = new FileReader( FunFOLD_directory+supfile );
					BufferedReader in1 = new BufferedReader(file1);
					String line1 = in1.readLine();
					String temppdbid = "";
					
					do
					{  
						// line containing PDB info
						if(line1.startsWith("REMARK Chain 1"))
						{
							StringTokenizer linetoke = new StringTokenizer(line1, ":.");
							String remark = linetoke.nextToken();
							//PDBID of the superposed template
							String PDB = linetoke.nextToken();
							temppdbid = PDB.substring(0, PDB.lastIndexOf("_"));
						}

						if(line1.startsWith("ATOM"))
						{
							//Makes sure that the PDBID of the superposed template in the file the same as the PDBID of the template under analysis
							if(temppdbid.equals(pdbid))
							{
								StringTokenizer atomtoke = new StringTokenizer(line1, " ");
								String atom = atomtoke.nextToken();
								String atomnumb = atomtoke.nextToken();
								String CA = atomtoke.nextToken();
								String templresitype = atomtoke.nextToken();
								String templresinumb = atomtoke.nextToken();
								String Xcoordstemp = line1.substring(30,38).trim();
								String Ycoordstemp = line1.substring(38,46).trim();
								String Zcoordstemp = line1.substring(47,54).trim();
								
								threeToOneAAConversion ttoaac = new threeToOneAAConversion( templresitype );
								String TLC = (String)ttoaac.getTLC();
								
								//Iterates through the vector of template binding site residues
								for (int k = 0; k <tempresiVect.size(); k++)
								{
									String Templateresinumb = (String)tempresiVect.elementAt(k); 
									
									// if the line in the template superposition file contains the binsing site reisudue it puts it in a vector 
									if(templresinumb.equals(Templateresinumb))
									{
										String resi = templresinumb + " " + TLC;
										String coords = Xcoordstemp + " " + Ycoordstemp + " " + Zcoordstemp;
										//Contains the binding site coords of the template binding site residues
										tempbindingcoordshash.put(resi, coords);
									}
								}	
							}
						}
						line1 = in1.readLine();
					}
					while(!line1.startsWith("TER"));
					
					//Reads through the superposition file
					while(line1.startsWith("CONECT"))
					{
						line1 = in1.readLine();
					}
					
					do
					{
						//Makes sure that the PDBID of the superposed template in the file the same as the PDBID of the template under analysis
						if(temppdbid.equals(pdbid))
						{
							if(line1.startsWith("ATOM"))
							{
								StringTokenizer atomtoke = new StringTokenizer(line1, " ");
								String atommodel = atomtoke.nextToken();
								String atomnumbmodel = atomtoke.nextToken();
								String CAmodel = atomtoke.nextToken();
								String modelresitype = atomtoke.nextToken();
								String modelresinumb = atomtoke.nextToken();
								String Xcoordsmodel = line1.substring(30,38).trim();
								String Ycoordsmodel = line1.substring(38,46).trim();
								String Zcoordstmodel = line1.substring(47,54).trim();
								
								threeToOneAAConversion ttoaac = new threeToOneAAConversion( modelresitype );
								String TLC = (String)ttoaac.getTLC();
								
								//run to get binding site residues of model
								//ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_directory+FunFOLD_outputfile );
								ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_outputfile );

								Vector typeVect = (Vector)ltv2.gettypeVect();
								Vector resiVect = (Vector)ltv2.getresiVect();
								//vector containing binding site residues
								Vector bsresiVect = (Vector)ltv2.getbsresiVect();
										
								//iterating through model binding site residues vector 
								for (int j = 0; j <bsresiVect.size(); j++)
								{	
									String modelbsresinumb = (String)bsresiVect.elementAt(j);
										
									//if the number of the residue in the model line is equal to the model binding site residue
									if(modelresinumb.equals(modelbsresinumb))
									{
										String modelresi = modelbsresinumb + " " + TLC;
										String modelcoords1 = Xcoordsmodel + " " + Ycoordsmodel + " " + Zcoordstmodel;
										//add in coords for model binding site residues into a hashtable 
										modelbindingcoordshash.put(modelresi , modelcoords1);
									}	
								}   
							}
							line1 = in1.readLine();	
						}				
					}
					while(!line1.startsWith("TER"));
					in1.close();
					
					
					float d = 3 ;//distance cutoff for Si score
					double totMaxSi = 0.0;
					//mean score for nearest residues of the template in the model
					float equivalentresiscore = 0;
					//mean BLOSUM62 score for nearest residues of the template in the model
					float equivblossresiscore = 0;

					for( Enumeration enumer = modelbindingcoordshash.keys(); enumer.hasMoreElements(); )
					{
						double maxSi = 0.0;
						double minDist = 0.0;
						String closest_res = "";
						String closest_restype = "";
						String numbtype1 = (String)enumer.nextElement();
						StringTokenizer newmodeltoks = new StringTokenizer(numbtype1," "); 
						String newmodnumb =  newmodeltoks.nextToken();
						String newmodtype =  newmodeltoks.nextToken();
						
						//Enumerate through the template binding site coords hashtable 
						for( Enumeration enumer1 = tempbindingcoordshash.keys(); enumer1.hasMoreElements(); )
						{	
							StringTokenizer numbtypetoks1 = new StringTokenizer(numbtype1, " ");
							String modelnumb = numbtypetoks1.nextToken();
							String modeltype = numbtypetoks1.nextToken();
								
							String modelcoords = (String)modelbindingcoordshash.get(numbtype1);
							StringTokenizer coordstoks1 = new StringTokenizer(modelcoords, " ");
							String modelxcoords = coordstoks1.nextToken();
							float ModelXcoords = (new Float(modelxcoords)).floatValue();
							String modelycoords = coordstoks1.nextToken();
							float ModelYcoords = (new Float(modelycoords)).floatValue();
							String modelzcoords = coordstoks1.nextToken();
							float ModelZcoords = (new Float(modelzcoords)).floatValue();
							
							String numbtype = (String)enumer1.nextElement();
							StringTokenizer numbtypetoks = new StringTokenizer(numbtype, " ");
							String tempnumb = numbtypetoks.nextToken();
							String temptype = numbtypetoks.nextToken();
							
							String tempcoords = (String)tempbindingcoordshash.get(numbtype );
							StringTokenizer coordstoks = new StringTokenizer(tempcoords, " ");
							String tempxcoords = coordstoks.nextToken();
							float TempXcoords = (new Float(tempxcoords)).floatValue();
							String tempycoords = coordstoks.nextToken();
							float TempYcoords = (new Float(tempycoords)).floatValue();
							String tempzcoords = coordstoks.nextToken();
							float TempZcoords = (new Float(tempzcoords)).floatValue();
							
							//calculate the distance between residues in the modela and the template 
							double distance = Math.sqrt( ((TempXcoords-ModelXcoords)*(TempXcoords-ModelXcoords)) + ((TempYcoords-ModelYcoords)*(TempYcoords-ModelYcoords)) + ((TempZcoords-ModelZcoords)*(TempZcoords-ModelZcoords)) );
							//calculate the si score 
							double Si = 1/(1+((distance/d)*(distance/d)));
							
							if( Si > maxSi )
							{
								maxSi = Si;
								minDist = distance;
								//find the closest equivalent residue of the template to the model
								closest_res = numbtype;	
								closest_restype = temptype;
								
							}	

						}
						totMaxSi = totMaxSi+maxSi;
						
						//If the model binding site residue is "A" 
						if(newmodtype.equals("A"))
						{
							//Enumerate through the BLOSUM62 "A" hashtable 
							for( Enumeration enumerA = resiAhash.keys(); enumerA.hasMoreElements(); )
							{
								String typeA = (String)enumerA.nextElement();
								String scoreA = (String)resiAhash.get(typeA);
								float ScoreA = (new Float(scoreA)).floatValue();
								
								//When closest equivalent residue in the template is found add the associated BLOSUM62 score to the total score 
								if(closest_restype.equals(typeA))
								{
									equivblossresiscore = equivblossresiscore + ScoreA;
								}
							}
						}
						
						if(newmodtype.equals("R"))
						{
							for( Enumeration enumerR = resiRhash.keys(); enumerR.hasMoreElements(); )
							{
								String typeR = (String)enumerR.nextElement();
								String scoreR = (String)resiRhash.get(typeR);
								float ScoreR = (new Float(scoreR)).floatValue();
								
								if(closest_restype.equals(typeR))
								{
									equivblossresiscore = equivblossresiscore + ScoreR;
								}	
							}
						}
						
						if(newmodtype.equals("N"))
						{
							for( Enumeration enumerN = resiNhash.keys(); enumerN.hasMoreElements(); )
							{
								String typeN = (String)enumerN.nextElement();
								String scoreN = (String)resiNhash.get(typeN);
								float ScoreN = (new Float(scoreN)).floatValue();
								
								if(closest_restype.equals(typeN))
								{
									equivblossresiscore = equivblossresiscore + ScoreN;
								}	
							}
						}
						
						if(newmodtype.equals("D"))
						{
							for( Enumeration enumerD = resiDhash.keys(); enumerD.hasMoreElements(); )
							{
								String typeD = (String)enumerD.nextElement();
								String scoreD = (String)resiDhash.get(typeD);
								float ScoreD = (new Float(scoreD)).floatValue();
								
								if(closest_restype.equals(typeD))
								{
									equivblossresiscore = equivblossresiscore + ScoreD;
								}	
							}
						}
						
						if(newmodtype.equals("C"))
						{
							for( Enumeration enumerC = resiChash.keys(); enumerC.hasMoreElements(); )
							{
								String typeC = (String)enumerC.nextElement();
								String scoreC = (String)resiChash.get(typeC);
								float ScoreC = (new Float(scoreC)).floatValue();
								
								if(closest_restype.equals(typeC))
								{
									equivblossresiscore = equivblossresiscore + ScoreC;
								}	
							}
						}
						
						
						
						if(newmodtype.equals("Q"))
						{
							for( Enumeration enumerQ = resiQhash.keys(); enumerQ.hasMoreElements(); )
							{
								String typeQ = (String)enumerQ.nextElement();
								String scoreQ = (String)resiQhash.get(typeQ);
								float ScoreQ = (new Float(scoreQ)).floatValue();
								
								if(closest_restype.equals(typeQ))
								{
									equivblossresiscore = equivblossresiscore + ScoreQ;
								}
							}
						}
						
						if(newmodtype.equals("E"))
						{
							for( Enumeration enumerE = resiEhash.keys(); enumerE.hasMoreElements(); )
							{
								String typeE = (String)enumerE.nextElement();
								String scoreE = (String)resiEhash.get(typeE);
								float ScoreE = (new Float(scoreE)).floatValue();
								
								if(closest_restype.equals(typeE))
								{
									equivblossresiscore = equivblossresiscore + ScoreE;
								}	
							}
						}
						
						if(newmodtype.equals("G"))
						{
							for( Enumeration enumerG = resiGhash.keys(); enumerG.hasMoreElements(); )
							{
								String typeG = (String)enumerG.nextElement();
								String scoreG = (String)resiGhash.get(typeG);
								float ScoreG = (new Float(scoreG)).floatValue();
								
								if(closest_restype.equals(typeG))
								{
									equivblossresiscore = equivblossresiscore + ScoreG;
								}	
							}
						}
						
						if(newmodtype.equals("H"))
						{
							for( Enumeration enumerH = resiHhash.keys(); enumerH.hasMoreElements(); )
							{
								String typeH = (String)enumerH.nextElement();
								String scoreH = (String)resiHhash.get(typeH);
								float ScoreH = (new Float(scoreH)).floatValue();
								
								if(closest_restype.equals(typeH))
								{
									equivblossresiscore = equivblossresiscore + ScoreH;
								}	
							}
						}
						
						if(newmodtype.equals("I"))
						{
							for( Enumeration enumerI = resiIhash.keys(); enumerI.hasMoreElements(); )
							{
								String typeI = (String)enumerI.nextElement();
								String scoreI = (String)resiIhash.get(typeI);
								float ScoreI = (new Float(scoreI)).floatValue();
								
								if(closest_restype.equals(typeI))
								{
									equivblossresiscore = equivblossresiscore + ScoreI;
								}	
							}
						}
						
						
						
						if(newmodtype.equals("L"))
						{
							for( Enumeration enumerL = resiLhash.keys(); enumerL.hasMoreElements(); )
							{
								String typeL = (String)enumerL.nextElement();
								String scoreL = (String)resiLhash.get(typeL);
								float ScoreL = (new Float(scoreL)).floatValue();
								
								if(closest_restype.equals(typeL))
								{
									equivblossresiscore = equivblossresiscore + ScoreL;
								}	
							}
						}
						
						if(newmodtype.equals("K"))
						{	
							for( Enumeration enumerK = resiKhash.keys(); enumerK.hasMoreElements(); )
							{
								String typeK = (String)enumerK.nextElement();
								String scoreK = (String)resiKhash.get(typeK);
								float ScoreK = (new Float(scoreK)).floatValue();
								
								if(closest_restype.equals(typeK))
								{
									equivblossresiscore = equivblossresiscore + ScoreK;
								}	
							}
						}
						
						if(newmodtype.equals("M"))
						{
							for( Enumeration enumerM = resiMhash.keys(); enumerM.hasMoreElements(); )
							{
								String typeM = (String)enumerM.nextElement();
								String scoreM = (String)resiMhash.get(typeM);
								float ScoreM = (new Float(scoreM)).floatValue();
								
								if(closest_restype.equals(typeM))
								{
									equivblossresiscore = equivblossresiscore + ScoreM;
								}	
							}
						}
						
						if(newmodtype.equals("F"))
						{
							for( Enumeration enumerF = resiFhash.keys(); enumerF.hasMoreElements(); )
							{
								String typeF = (String)enumerF.nextElement();
								String scoreF = (String)resiFhash.get(typeF);
								float ScoreF = (new Float(scoreF)).floatValue();
								
								if(closest_restype.equals(typeF))
								{
									equivblossresiscore = equivblossresiscore + ScoreF;
								}	
							}
						}
						
						if(newmodtype.equals("P"))
						{
							for( Enumeration enumerP = resiPhash.keys(); enumerP.hasMoreElements(); )
							{
								String typeP = (String)enumerP.nextElement();
								String scoreP = (String)resiPhash.get(typeP);
								float ScoreP = (new Float(scoreP)).floatValue();
								
								if(closest_restype.equals(typeP))
								{
									equivblossresiscore = equivblossresiscore + ScoreP;
								}	
							}
						}
						
						
						
						if(newmodtype.equals("S"))
						{
							for( Enumeration enumerS = resiShash.keys(); enumerS.hasMoreElements(); )
							{
								String typeS = (String)enumerS.nextElement();
								String scoreS = (String)resiShash.get(typeS);
								float ScoreS = (new Float(scoreS)).floatValue();
								
								if(closest_restype.equals(typeS))
								{
									equivblossresiscore = equivblossresiscore + ScoreS;
								}	
							}
						}
						
						if(newmodtype.equals("T"))
						{
							for( Enumeration enumerT = resiThash.keys(); enumerT.hasMoreElements(); )
							{
								String typeT = (String)enumerT.nextElement();
								String scoreT = (String)resiThash.get(typeT);
								float ScoreT = (new Float(scoreT)).floatValue();
								
								if(closest_restype.equals(typeT))
								{
									equivblossresiscore = equivblossresiscore + ScoreT;;
								}
							}
						}
						
						if(newmodtype.equals("W"))
						{
							for( Enumeration enumerW = resiWhash.keys(); enumerW.hasMoreElements(); )
							{
								String typeW = (String)enumerW.nextElement();
								String scoreW = (String)resiWhash.get(typeW);
								float ScoreW = (new Float(scoreW)).floatValue();
								
								if(closest_restype.equals(typeW))
								{
									equivblossresiscore = equivblossresiscore + ScoreW;
								}	
							}
						}
						
						if(newmodtype.equals("Y"))
						{
							for( Enumeration enumerY = resiYhash.keys(); enumerY.hasMoreElements(); )
							{
								String typeY = (String)enumerY.nextElement();
								String scoreY = (String)resiYhash.get(typeY);
								float ScoreY = (new Float(scoreY)).floatValue();
								
								if(closest_restype.equals(typeY))
								{
									equivblossresiscore = equivblossresiscore + ScoreY;
								}	
							}
						}
						
						if(newmodtype.equals("V"))
						{
							for( Enumeration enumerV = resiVhash.keys(); enumerV.hasMoreElements(); )
							{
								String typeV = (String)enumerV.nextElement();
								String scoreV = (String)resiVhash.get(typeV);
								float ScoreV = (new Float(scoreV)).floatValue();
								
								if(closest_restype.equals(typeV))
								{
									equivblossresiscore = equivblossresiscore + ScoreV;
								}
							}
						}
						
						
						
						if(newmodtype.equals("B"))
						{
							for( Enumeration enumerB = resiBhash.keys(); enumerB.hasMoreElements(); )
							{
								String typeB = (String)enumerB.nextElement();
								String scoreB = (String)resiBhash.get(typeB);
								float ScoreB = (new Float(scoreB)).floatValue();
								
								if(closest_restype.equals(typeB))
								{
									equivblossresiscore = equivblossresiscore + ScoreB;
								}	
							}
						}
						
						if(newmodtype.equals("J"))
						{
							for( Enumeration enumerJ = resiJhash.keys(); enumerJ.hasMoreElements(); )
							{
								String typeJ = (String)enumerJ.nextElement();
								String scoreJ = (String)resiJhash.get(typeJ);
								float ScoreJ = (new Float(scoreJ)).floatValue();
								
								if(closest_restype.equals(typeJ))
								{
									equivblossresiscore = equivblossresiscore + ScoreJ;
								}	
							}
						}
						
						if(newmodtype.equals("Z"))
						{
							for( Enumeration enumerZ = resiZhash.keys(); enumerZ.hasMoreElements(); )
							{
								String typeZ = (String)enumerZ.nextElement();
								String scoreZ = (String)resiZhash.get(typeZ);
								float ScoreZ = (new Float(scoreZ)).floatValue();
								
								if(closest_restype.equals(typeZ))
								{
									equivblossresiscore = equivblossresiscore + ScoreZ;
								}	
							}
						}
						
						
						if(newmodtype.equals("X"))
						{
							for( Enumeration enumerX = resiXhash.keys(); enumerX.hasMoreElements(); )
							{
								String typeX = (String)enumerX.nextElement();
								String scoreX = (String)resiXhash.get(typeX);
								float ScoreX = (new Float(scoreX)).floatValue();
								
								if(closest_restype.equals(typeX))
								{
									equivblossresiscore = equivblossresiscore + ScoreX;
								}	
							}
						}
						
						//if the equivalent resiude in the model and the template are equal qive score of one
						if(newmodtype.equals(closest_restype))
						{
							equivalentresiscore++;
						}
							
					}   
					//normalize the score by maximun number of binding site residues between the model and the template
					float norm = Math.max( tempbindingcoordshash.size(), modelbindingcoordshash.size() );
					float modelnorm = modelbindingcoordshash.size();
					float tempnorm = tempbindingcoordshash.size();
					//System.out.println("norm "+ norm );
					float diff = 0;
					float balancescore = 0;
					
					//if the maximun number of binding site reisudes (norm) is greather than the number of binding site residues in the template add -4 to the BLOSUM score for each extra non equilavent residue
					if(norm > tempnorm)
					{
						diff = (norm-tempnorm);
						balancescore = (-4*diff);
					}
					
					//if the maximun number of binding site reisudes (norm) is greather than the number of binding site residues in the model add -4 to the BLOSUM score for each extra non equilavent residue
					if(norm > modelnorm)
					{
						diff = (norm-modelnorm);
						balancescore = (-4*diff);
						//System.out.println("balancescore " + balancescore);
					}
					//calculate the mean equivalent score for each template
					float meanequivalentresiscore = (equivalentresiscore/norm);
					//calculate the mean equivalent BLOSUM62 score for each template
					float meanequivblossresiscore = ((equivblossresiscore+balancescore)/(norm+diff));
					//normalize the mean equivalent BLOSUM62 score for each template between 0 and 1
					float normalizedmeanequivblossresiscore = ((meanequivblossresiscore + 4 )/(10));
					
					//add the equivalent scores to a vector
					equiBlossVect.add(meanequivblossresiscore);	
					equiResiVect.add(meanequivalentresiscore);
				}
			}
			int numboftemplates = 0;
 			float totequivalentresiscore = 0;
			float totequivalentblossscore = 0;
 			
			//iterate the equivalent residue template vector to get a mean score for all of the templates compared to the model
 			for (int j = 0; j <equiResiVect.size(); j++)
 			{
 				Float equviResiScore = (Float)equiResiVect.elementAt(j);
 				  
 				numboftemplates++;
				totequivalentresiscore += equviResiScore;
 			}
 			meanequiresiscore = (totequivalentresiscore/numboftemplates);
			
			
			//iterate the equivalent residue template vector to get a mean BLOSUM62 score for all of the templates compared to the model
			for (int q = 0; q <equiBlossVect.size(); q++)
 			{
 				Float equviBlossScore = (Float)equiBlossVect.elementAt(q);
				
				totequivalentblossscore += equviBlossScore;
 			}
 			meanequiblossscore = (totequivalentblossscore/numboftemplates);
			
			//normalize the mean BLOSUM62 score for all of the templates compared to the model
			normalizedmeanequiblossscore = ((meanequiblossscore + 4 )/(15));
 			
			//System.out.println("Number of templates: " + numboftemplates);	
			
			//System.out.println("Identity = " + meanequiresiscore);	
			
			//System.out.println("mean equivalent BLOSUM62 score: " + meanequiblossscore);	
			
			//System.out.println("Rescaled BLOSUM62 = " + normalizedmeanequiblossscore);	
			
			System.out.println("Finished calculating Identity and Rescaled BLOSUM62 scores");
			
		}
	
		catch( Exception e )
		{
			System.out.println( "Error executing equivalentResidueTypeAnalysis! " + e );
		}	
	}

 	public float getmeanequiresiscore()
 	{
 		return meanequiresiscore;
 	}
	
	public float getnormalizedmeanequiblossscore()
 	{
 		return normalizedmeanequiblossscore;
 	}

	public static void main( String args[])
	{
		equivalentResidueTypeAnalysis erta = new equivalentResidueTypeAnalysis( args[0], args[1], args[2], args[3], args[4] );
		float meanequiresiscore = (Float)erta.getmeanequiresiscore();
		float normalizedmeanequiblossscore = (Float)erta.getnormalizedmeanequiblossscore();
	
	}
}
			