import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*equivalentLigResiDist - runs templateListParser.java to find templates with TMscore > 0.4 containing biologically relevant ligands, then calculates the binding site residues for each of those templates using  proLigContacts.java - runs ligTypeVariation_V2.java to find the binding site resiudes of the model - superposes the model and the template using pymol and the TMsup*_all files so that the ligand is in the correct location in relation to the template and the model - reads in the model file after the pymol superposition to get the correct coordintaes for the binding site resides and the ligand puts both the binding site residues and ligand coordinates into a hashtable - reads in the FunFOLD output superposition files TMsup*_all puts the coords of binding site residues for teamplate into hashtables - the nearset structurally equilavent model binding site residues in the templates are found then the equilavent residues are put in a hashtable - next the shortest distance beteeen each residue in both the model and template binding sites and the ligand are calculated - the difference between the shortest distance of equivalent template and model binding site residues to the ligand are calculated and a mean distance difference is calculated for each model to template comparison - an overall mean distance difference is finally calculated for all of the templates and output -  the vdw file is also read in to make sure the shortest distance is within the cutoff for binding site residues then converted the scores in to a Q-score between 0 and 1
*/

public class equivalentLigResiDist
{
	Runtime r = Runtime.getRuntime();
	Process p = null;
	Vector equivligandresivect = new Vector();
	Vector qscoreequivligandresivect = new Vector();
	float meandistancedifference;
	float meanqscore;
	
	public equivalentLigResiDist( String FunFOLD_directory, String templatelist,  String FunFOLD_outputfile, String topmodel, String target )
	{
		try
		{
			//determines the mean TM-score for for all templates with biologically relevant ligands and a template score for the number of templates divided the number of biologically revelant templates - using to find the templates that are used in FunFOLD for the determination of binding site residues
			System.out.println( "Calculating Equivalent Residue Ligand Distance score" );

			templateListParser tmplp = new templateListParser( FunFOLD_directory, templatelist, topmodel, target );

			//Vector templatevect = (Vector)tmplp.gettemplatevect();
			Vector relevantTemplateVect = (Vector)tmplp.getrelevantTemplateVect();

			//System.out.println(relevantTemplateVect); //TEMP
			int templatenumb = 0;
			
			for (int i = 0; i <relevantTemplateVect.size(); i++)
			{

				Hashtable tempbindingcoordshash = new Hashtable();
				Hashtable modelbindingcoordshash = new Hashtable();
				Hashtable hetatmcoordscoordshash = new Hashtable();
				Hashtable closestequivresihash = new Hashtable();
				Vector tempresiVect = new Vector();
				Vector temptypeVect = new Vector();
				
				//to determine which template is being examined to find the correct superposition file 
				templatenumb++;

				//Determines what each template is 
				String template = (String)relevantTemplateVect.elementAt(i);
				
				String templateNAME = template+"_lig_temp.pdb";
				
				//finds the binding site residues of the biologically relevant templates 
				proLigContacts plc = new proLigContacts( FunFOLD_directory + template+".pdb" );
				Hashtable resultshash = (Hashtable)plc.getresultshash();
				
				String pdbid =  template.substring( 0, template.lastIndexOf("_") );
				String bsfile = pdbid+"_bs.out";
				
 				if( resultshash.size() > 0 )
				{
 
					//Enumerates through the hashtable of binding site reisidue types and numbers 
					for( Enumeration enumer2 = resultshash.keys(); enumer2.hasMoreElements(); )
					{
						String results = (String)enumer2.nextElement();
						StringTokenizer resultstoks = new StringTokenizer(results, ",[]");
						
						while(resultstoks.hasMoreTokens())
						{
							String tempresinumbtype = resultstoks.nextToken();
							StringTokenizer temptypenumbtoke = new StringTokenizer( tempresinumbtype, " " );
							String tempresinumb = temptypenumbtoke.nextToken();
							String tempresitype = temptypenumbtoke.nextToken();
							tempresiVect.add(tempresinumb);
							temptypeVect.add(tempresitype);
						}
					}	

					
					//names the superposition file which is dependant on the template under examination
					String supfile = "TM.sup"+templatenumb+"_all";
					String templateName = pdbid + "_lig.pdb_lig_temp.pdb";
					String TemplatePDBname = pdbid+"_lig.pdb_lig_temp";
					String TopModel = "";

					if( ( new File( FunFOLD_directory+"/"+supfile) ).exists() )
					{
						// if the model ends with .pdb it needs to be removed as pymol will remove it 
						if(topmodel.endsWith(".pdb"))
						{
						      TopModel = topmodel.substring(0 , topmodel.lastIndexOf("."));
						      
						}  
						
						else
						{
							TopModel = topmodel;
						}
						
						String aligncommands = "align "+ TopModel + ", " +  supfile + " ; align "+ TemplatePDBname + ", " + supfile + " ; ";
						String outputFileName = pdbid+"_"+TopModel+"_lig.pdb";
						
						//need to run pymol to superpose the modelonto the template - just to get the correct location of the ligand in the model binding site 
						if( !( new File( FunFOLD_directory+"/"+outputFileName) ).exists() )
						{
                            //fix "bug" with new version of pymol, which checks file extensions are .pdb annoyingly!
                            String[] cpfix = {"/bin/bash", "-c", "cd " + FunFOLD_directory + ";cp " + topmodel + " " + topmodel + ".pdb;cp " + supfile + " " + supfile + ".pdb" };
                            p = r.exec( cpfix );
                            p.waitFor();
                            p.destroy();
                            
                            String[] runpymol = {"/bin/bash", "-c", "cd " + FunFOLD_directory + ";$PYMOL_HOME/pymol -c " + topmodel +".pdb "+ templateName + " " + supfile+ ".pdb " + "-d '" + aligncommands + " save " + outputFileName +"' > runpymol.out.log 2> runpymol.err.log"};
							p = r.exec( runpymol ); //TEMP
							p.waitFor();
							p.destroy();
						
                            //ORIGINAL VERSION
// 							String[] runpymol = {"/bin/bash", "-c", "cd " + FunFOLD_directory + ";$PYMOL_HOME/pymol -c " + topmodel +" "+ templateName + " " + supfile+ " " + "-d '" + aligncommands + " save " + outputFileName +"' > runpymol.out.log 2> runpymol.err.log"};
// 							p = r.exec( runpymol ); //TEMP
// 							p.waitFor();
// 							p.destroy();
						}
	
						FileReader file1 = new FileReader( FunFOLD_directory + outputFileName );
						BufferedReader in1 = new BufferedReader(file1);
						String line1 = in1.readLine();
					
					
						//Read through the pymol superposition to get the model in the correct 3D space in relation to the template
						do
						{  
							if(line1.startsWith("ATOM"))
							{
								StringTokenizer atomtoke = new StringTokenizer(line1, " ");
								String CA = line1.substring(13,17).trim();
								String modelresitype = line1.substring(18,21).trim();
								String modelresinumb = line1.substring(23,28).trim();
								String Xcoordsmodel = line1.substring(30,38).trim();
								String Ycoordsmodel = line1.substring(38,46).trim();
								String Zcoordsmodel = line1.substring(47,54).trim();

								//run to get binding site residues of model
								ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_outputfile );								
								//ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_directory+FunFOLD_outputfile );
								Vector typeVect = (Vector)ltv2.gettypeVect();
								Vector resiVect = (Vector)ltv2.getresiVect();
								//vector containing binding site residues
								Vector bsresiVect = (Vector)ltv2.getbsresiVect();
								
								//Only need the C alpha atoms for distance comparison
								if(CA.equals("CA"))
								{		
									//iterating through model binding site residues vector 
									for (int j = 0; j <bsresiVect.size(); j++)
									{	
										String modelbsresinumb = (String)bsresiVect.elementAt(j);
										//if the number of the residue in the model line is equal to the model binding site residue
										if(modelresinumb.equals(modelbsresinumb))
										{
											String modelresi = modelbsresinumb + " " + modelresitype;
											String modelcoords1 = Xcoordsmodel + " " + Ycoordsmodel + " " + Zcoordsmodel;
											//add in coords for model binding site residues into a hashtable 
											modelbindingcoordshash.put(modelresi , modelcoords1);
										}	
									} 
									
								}
							}
							line1 = in1.readLine();												
						}
						while(line1 != null );
						in1.close();

						FileReader file2 = new FileReader( FunFOLD_directory +template +".pdb_hetatm.out" );
						BufferedReader in2 = new BufferedReader(file2);
						String line2 = in2.readLine();
						
						//get the ligand in the correct 3D space in relation to the model and template 
						do
						{  
							if(line2.startsWith("HETATM"))
							{
								String hresinumb = line2.substring(25, 28).trim();
								String hresitype = line2.substring(76, 78).trim().toUpperCase();
								String hresi = hresinumb + " " + hresitype;
								String hXcoords = line2.substring(30,38).trim();
								String hYcoords = line2.substring(38,46).trim();
								String hZcoords = line2.substring(47,54).trim();
								String hcoords = hXcoords + " " + hYcoords + " " + hZcoords + " " + hresitype;
								//Contains the binding site coords of the template binding site residues
								hetatmcoordscoordshash.put(hresi, hcoords);
							}
							line2 = in2.readLine();
						}
						while(line2 != null);
						in2.close();

						//Reads through the superposition file to get the template in the correct 3D space in relation to the model
						FileReader supfilereader = new FileReader( FunFOLD_directory +  supfile );
						BufferedReader supbuff = new BufferedReader(supfilereader);
						String supline = supbuff.readLine();
						
						do
						{
							//Read in superposition files to get coordinates of template binding site residues
							
							if(supline.startsWith("ATOM"))
							{																		String atomnumbtemp = supline.substring(5, 11).trim();
								String CAtemp = supline.substring(12, 15).trim().toUpperCase();
								String templresinumb = supline.substring(22, 26).trim();
								String Xcoordstemp = supline.substring(30,38).trim();
								String Ycoordstemp = supline.substring(38,46).trim();
								String Zcoordstemp = supline.substring(47,54).trim();
								
								//enumerate through the template binding site residue vector 
								for (int k = 0; k <tempresiVect.size(); k++)
								{
									String Templateresinumb = (String)tempresiVect.elementAt(k); 
										
									// if the line in the template superposition file contains the binsing site reisudue it puts it in a vector 
									if(templresinumb.equals(Templateresinumb))
									{
										String resi = templresinumb + " " + CAtemp;
										String coords = Xcoordstemp + " " + Ycoordstemp + " " + Zcoordstemp;
										//Contains the binding site coords of the template binding site residues
										tempbindingcoordshash.put(resi, coords);
									}
								}

							}
							supline = supbuff.readLine();
											
						}
						while(!supline.startsWith("TER"));
						supbuff.close();

						float d = 3 ;//distance cutoff for Si score
						double totMaxSi = 0.0;

						if( (tempbindingcoordshash.size() > 0) && (modelbindingcoordshash.size() > 0) && (hetatmcoordscoordshash.size() > 0))
						{
							//find closest equivalent residues in the template to the model
							for( Enumeration enumer = modelbindingcoordshash.keys(); enumer.hasMoreElements(); )
							{
								double maxSi = 0.0;
								double minDist = 0.0;
								String closest_res = "";
								String closest_restype = "";
								String closestequiv = "";
								String modelresicoords = "";
								String numbtype1 = (String)enumer.nextElement();
								StringTokenizer newmodeltoks = new StringTokenizer(numbtype1," "); 
								String newmodnumb =  newmodeltoks.nextToken();
								String newmodtype =  newmodeltoks.nextToken();
								
								//Enumerate through the template binding site coords hashtable 
								for( Enumeration enumer1 = tempbindingcoordshash.keys(); enumer1.hasMoreElements(); )
								{	
									StringTokenizer numbtypetoks1 = new StringTokenizer(numbtype1, " ");
									String modelnumb = numbtypetoks1.nextToken();
									String modeltype = numbtypetoks1.nextToken();
										
									String modelcoords = (String)modelbindingcoordshash.get(numbtype1);
									StringTokenizer coordstoks1 = new StringTokenizer(modelcoords, " ");
									String modelxcoords = coordstoks1.nextToken();
									float ModelXcoords = (new Float(modelxcoords)).floatValue();
									String modelycoords = coordstoks1.nextToken();
									float ModelYcoords = (new Float(modelycoords)).floatValue();
									String modelzcoords = coordstoks1.nextToken();
									float ModelZcoords = (new Float(modelzcoords)).floatValue();
									
									modelresicoords = numbtype1 + " " + modelcoords;
									
									String numbtype = (String)enumer1.nextElement();
									StringTokenizer numbtypetoks = new StringTokenizer(numbtype, " ");
									String tempnumb = numbtypetoks.nextToken();
									String temptype = numbtypetoks.nextToken();
									
									String tempcoords = (String)tempbindingcoordshash.get(numbtype );
									StringTokenizer coordstoks = new StringTokenizer(tempcoords, " ");
									String tempxcoords = coordstoks.nextToken();
									float TempXcoords = (new Float(tempxcoords)).floatValue();
									String tempycoords = coordstoks.nextToken();
									float TempYcoords = (new Float(tempycoords)).floatValue();
									String tempzcoords = coordstoks.nextToken();
									float TempZcoords = (new Float(tempzcoords)).floatValue();
									
									//calculate the distance between residues in the modela and the template 
									double distance = Math.sqrt( ((TempXcoords-ModelXcoords)*(TempXcoords-ModelXcoords)) + ((TempYcoords-ModelYcoords)*(TempYcoords-ModelYcoords)) + ((TempZcoords-ModelZcoords)*(TempZcoords-ModelZcoords)) );
				
									//calculate the si score 
									double Si = 1/(1+((distance/d)*(distance/d)));
									
									if( Si > maxSi )
									{
										maxSi = Si;
										minDist = distance;
										//find the closest equivalent residue of the template to the model
										closest_res = numbtype;	
										closest_restype = temptype;
										closestequiv = numbtype + " " + tempcoords;
										
									}	
								}
								totMaxSi = totMaxSi+maxSi;

								closestequivresihash.put(  modelresicoords , closestequiv ); 
							}   
							
							//enumerate through the equivalent residue hast then the ligand hash to find the closest distance between ligand and binding site residue mean score for nearest residues of the template in the model
							double totMaxModelSi = 0.0;
							double totMaxTemplateSi = 0.0;
							double totaldistdiff = 0.0;
							double totalqscore = 0.0;
	// 						
							for( Enumeration enumer2 = closestequivresihash.keys(); enumer2.hasMoreElements(); )
							{
								double maxmodelSi = 0.0;
								double minmodelDist = 0.0;
								String closestmodel_res = "";
								String closestmodel_restype = "";
								
								double maxtemplateSi = 0.0;
								double mintemplateDist = 0.0;
								String closesttemplate_res = "";
								String closesttemplate_restype = "";
								
								String ATOMTYPE = "C";
								double distancedifference = 0.0;
								double Qscore = 0.0;
								
								String modelresidetains = (String)enumer2.nextElement();
								StringTokenizer modeldetailstoks = new StringTokenizer(modelresidetains," "); 
								String modelResiNum =  modeldetailstoks.nextToken();
								String modelResiType =  modeldetailstoks.nextToken();
								
								//Enumerate through the template binding site coords hashtable 
								for( Enumeration enumer3 = hetatmcoordscoordshash.keys(); enumer3.hasMoreElements(); )
								{	
									StringTokenizer modeldetailstoks1 = new StringTokenizer(modelresidetains, " ");
									String modelResiNum1 = modeldetailstoks1.nextToken();
									String modelResiType1 = modeldetailstoks1.nextToken();
									String modxcoords = modeldetailstoks1.nextToken();
									float ModXcoords = (new Float(modxcoords)).floatValue();
									String modycoords = modeldetailstoks1.nextToken();
									float ModYcoords = (new Float(modycoords)).floatValue();
									String modzcoords = modeldetailstoks1.nextToken();
									float ModZcoords = (new Float(modzcoords)).floatValue();
									
									//find the details of the equivalent template residue including coords
									String templatedetails = (String)closestequivresihash.get(modelresidetains);
									StringTokenizer templatedetailstoks = new StringTokenizer(templatedetails, " ");
									String TemplateResiNum = templatedetailstoks.nextToken();
									String TemplateResiType = templatedetailstoks.nextToken();
									String templatexcoords = templatedetailstoks.nextToken();
									float TemplateXcoords = (new Float(templatexcoords)).floatValue();
									String templateycoords = templatedetailstoks.nextToken();
									float TemplateYcoords = (new Float(templateycoords)).floatValue();
									String templatezcoords = templatedetailstoks.nextToken();
									float TemplateZcoords = (new Float(templatezcoords)).floatValue();
				
									// get the details of the hetatom including the coords 
									String hetatmdetails = (String)enumer3.nextElement();
									StringTokenizer hetatmtoks = new StringTokenizer(hetatmdetails, " ");
									String HetatmResiNumb = hetatmtoks.nextToken();
									String HetatmResiType = hetatmtoks.nextToken();
									String Hetatmcoords = (String)hetatmcoordscoordshash.get(hetatmdetails);
									StringTokenizer Hetatmcoordstoks = new StringTokenizer(Hetatmcoords, " ");
									String hetatmxcoords = Hetatmcoordstoks.nextToken();
									float HetatmXcoords = (new Float(hetatmxcoords)).floatValue();
									String hetatmycoords = Hetatmcoordstoks.nextToken();
									float HetatmYcoords = (new Float(hetatmycoords)).floatValue();
									String hetatmzcoords = Hetatmcoordstoks.nextToken();
									float HetatmZcoords = (new Float(hetatmzcoords)).floatValue();
									String hetatom = Hetatmcoordstoks.nextToken().toUpperCase();

									//calculate the distance between residues in the modela and the template 
									double templatedistance = Math.sqrt( ((TemplateXcoords-HetatmXcoords)*(TemplateXcoords-HetatmXcoords)) + ((TemplateYcoords-HetatmYcoords)*(TemplateYcoords-HetatmYcoords)) + ((TemplateZcoords-HetatmZcoords)*(TemplateZcoords-HetatmZcoords)) );
									//calculate the si score 
									double templateSi = 1/(1+((templatedistance/d)*(templatedistance/d)));

									if( templateSi > maxtemplateSi )
									{
										maxtemplateSi = templateSi;
										mintemplateDist = templatedistance;
										//find the closest equivalent residue of the template to the model
										closesttemplate_res = TemplateResiNum;	
										closestmodel_restype = TemplateResiType;
						
									}	
									
									double modeldistance = Math.sqrt( ((ModXcoords-HetatmXcoords)*(ModXcoords-HetatmXcoords)) + ((ModYcoords-HetatmYcoords)*(ModYcoords-HetatmYcoords)) + ((ModZcoords-HetatmZcoords)*(ModZcoords-HetatmZcoords)) );
									double modelSi = 1/(1+((modeldistance/d)*(modeldistance/d)));
									

									if( modelSi > maxmodelSi )
									{
										maxmodelSi = modelSi;
										minmodelDist = modeldistance;
										//find the closest equivalent residue of the template to the model
										closestmodel_res = modelResiNum1;	
										closestmodel_restype = modelResiType1;
	
									}
	
								}
								totMaxModelSi = totMaxModelSi + maxmodelSi;
								totMaxTemplateSi = totMaxTemplateSi + maxtemplateSi;
								
								distancedifference = Math.abs(mintemplateDist - minmodelDist);

								Qscore = Math.exp(-distancedifference);
								
								totaldistdiff += distancedifference;
								
								totalqscore +=Qscore;
								
							}
							
							
						float norm = Math.max( tempbindingcoordshash.size(), modelbindingcoordshash.size() );
						double normalizeddistdiff = (totaldistdiff/norm);
						
						double Qtotal = ((totalqscore)/(norm));
						
						equivligandresivect.add(normalizeddistdiff);
						qscoreequivligandresivect.add(Qtotal);
						}
					}
					
 				}
			}

				int numboftemplates = 0;
				float totnormalizeddistancediff = 0;

				//iterate the equivalent residue template vector to get a mean score for all of the templates compared to the model
				for (int z = 0; z <equivligandresivect.size(); z++)
				{
					Double normalizeddistancediff = (Double)equivligandresivect.elementAt(z);
					numboftemplates++;
					totnormalizeddistancediff += normalizeddistancediff;
				}	
				meandistancedifference = (totnormalizeddistancediff/numboftemplates);

				float totnormalizedqtotal = 0;

				//iterate the equivalent residue template vector to get a mean Qtotal for all of the templates compared to the model
				for (int m = 0; m <qscoreequivligandresivect.size(); m++)
				{
					Double normalizedqtotal = (Double)qscoreequivligandresivect.elementAt(m);
					totnormalizedqtotal += normalizedqtotal;
				}
					
				meanqscore = (totnormalizedqtotal/numboftemplates);
				//System.out.println("Equivalent Residue Ligand Distance = "+ meanqscore);
				System.out.println( "Finished calculating Equivalent Residue Ligand Distance score" );
		}	
	
		catch( Exception e )
		{
			System.out.println( "Error executing equivalentLigResiDist! " + e );
		}	
	}

 	public float getmeandistancedifference()
 	{
 		return meandistancedifference;
 	}
	
	public float getmeanqscore()
	{
		return meanqscore;
	}

	public static void main( String args[])
	{
		equivalentLigResiDist elrd = new equivalentLigResiDist( args[0], args[1], args [2], args[3], args[4] );
		float meandistancedifference = (Float)elrd.getmeandistancedifference();
		float meanqscore = (Float)elrd.getmeanqscore();
	
	}
}
			
