import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*CAMEOScoringCode - produces per residue scoring for ligand types I - Ion, N - Nucleic Acids, O - Organic ligands P - Peptides - basically the ropability of each binding site residue binding to these specific ligand types 
*/

public class CAMEOScoringCode
{

	Vector equivligandresivect = new Vector();
	Vector qscoreequivligandresivect = new Vector();
	float meandistancedifference;
	float meanqscore;
        DecimalFormat df = new DecimalFormat("0.000");
	StringBuffer outputresults = new StringBuffer();
        String LigResults = "";
	
	public CAMEOScoringCode( String FunFOLD_directory, String FunFOLD_outputfile, String lig2file, String target )
	{
		try
		{

			System.out.println( "Calculation per residue binding site biochemical propensity scores.................." );
 					
			// I need to read in the model *.lig2 file that contains the top model and the superposed ligands in the correct 3D space //
			//Read through the pymol superposition to get the model in the correct 3D space in relation to the template
						
			FileReader file1 = new FileReader( FunFOLD_directory + lig2file );
			BufferedReader in1 = new BufferedReader(file1);
			String line1 = in1.readLine();


			Hashtable modelbindingcoordshash = new Hashtable();
			Hashtable hetatmcoordscoordshash = new Hashtable();

			do
			{  
			    if(line1.startsWith("ATOM"))
			    {
				StringTokenizer atomtoke = new StringTokenizer(line1, " ");
				String CA = line1.substring(13,17).trim();
				String modelresitype = line1.substring(17,22).trim();
				String modelresinumb = line1.substring(23,28).trim();
				String Xcoordsmodel = line1.substring(30,38).trim();
				String Ycoordsmodel = line1.substring(38,46).trim();
				String Zcoordsmodel = line1.substring(47,54).trim();
				
				//System.out.println("Reading in atom file " + modelresinumb);

				//run to get binding site residues of model
				//ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_outputfile );								
				ligTypeVariation_V2 ltv2 = new ligTypeVariation_V2( FunFOLD_outputfile );
				Vector typeVect = (Vector)ltv2.gettypeVect();
				Vector resiVect = (Vector)ltv2.getresiVect();
				//vector containing binding site residues
				Vector bsresiVect = (Vector)ltv2.getbsresiVect();
				//System.out.println("running ligTypeVariation_V2 " + bsresiVect);
								
				//Only need the C alpha atoms for distance comparison
				if(CA.equals("CA"))
				{		
					//iterating through model binding site residues vector 
				    for (int j = 0; j <bsresiVect.size(); j++)
				    {	
					String modelbsresinumb = (String)bsresiVect.elementAt(j);
					//if the number of the residue in the model line is equal to the model binding site residue
					if(modelresinumb.equals(modelbsresinumb))
					{
						    String modelresi = modelbsresinumb + " " + modelresitype;
						    String modelcoords1 = Xcoordsmodel + " " + Ycoordsmodel + " " + Zcoordsmodel;
						    //add in coords for model binding site residues into a hashtable 
						    modelbindingcoordshash.put(modelresi , modelcoords1);
						    //System.out.println(" modelbindingcoordshash" + modelbindingcoordshash);
					}	
				    } 
									
				}

			    }
			    //line1 = in1.readLine();	

			    //System.out.println(" modelbindingcoordshash" + modelbindingcoordshash);
			    // I need to get the ligand coordinates here too - maybe categorize then put into hashtable  

			    if(line1.startsWith("HETATM"))
			    {
				    String hresinumb = line1.substring(25, 28).trim();

				    //String hresitype = line1.substring(73, 80).trim().toUpperCase();
				    String hresitype = line1.substring(15, 21).trim().toUpperCase();
				    String hresi = hresinumb + " " + hresitype;
				    String hXcoords = line1.substring(30,38).trim();
				    String hYcoords = line1.substring(38,46).trim();
				    String hZcoords = line1.substring(47,54).trim();
				    String hcoords = hXcoords + " " + hYcoords + " " + hZcoords + " " + hresitype;
				    //Contains the binding site coords of the template binding site residues
				    hetatmcoordscoordshash.put(hresi, hcoords);
			    }
			    line1 = in1.readLine();

			     //System.out.println("hetatmcoordscoordshash " + hetatmcoordscoordshash);
											
			}
			while(line1 != null );
			in1.close();

			//The distance of the ligand binding site residues need to be compared to the ligands to find the closest ligand using the Si score - think about ligand categories here !!
			//For multiple ligands Types - get multiple Si scores 

			float d = 3 ;//distance cutoff for Si score
			double totMaxSi = 0.0;

			Hashtable siHash = new Hashtable();

			if( (modelbindingcoordshash.size() > 0) && (hetatmcoordscoordshash.size() > 0))
			{
				
							
			    //enumerate through the equivalent residue hast then the ligand hash to find the closest distance between ligand and binding site residue mean score for nearest residues of the template in the model
			    double totMaxModelSi = 0.0;
			    double totMaxTemplateSi = 0.0;
			    double totaldistdiff = 0.0;
			    double totalqscore = 0.0;
			    // 						
			    for( Enumeration enumer2 = modelbindingcoordshash.keys(); enumer2.hasMoreElements(); )
			    {
				double maxmodelSi = 0.0;
				double minmodelDist = 0.0;
				String closestmodel_res = "";
				String closestmodel_restype = "";
				String closestlig_res = "";
				String closestlig_restype = "";
								
				String ATOMTYPE = "C";
				double distancedifference = 0.0;
				double Qscore = 0.0;
								
				String modelresidetains = (String)enumer2.nextElement();
				StringTokenizer modeldetailstoks = new StringTokenizer(modelresidetains," "); 
				String modelResiNum =  modeldetailstoks.nextToken();
				String modelResiType =  modeldetailstoks.nextToken();

				//Enumerate through the template binding site coords hashtable 
				for( Enumeration enumer3 = hetatmcoordscoordshash.keys(); enumer3.hasMoreElements(); )
				{	
				    StringTokenizer modeldetailstoks1 = new StringTokenizer(modelresidetains, " ");
				    String modelResiNum1 = modeldetailstoks1.nextToken();
				    String modelResiType1 = modeldetailstoks1.nextToken();
				    String modelcoords = (String)modelbindingcoordshash.get(modelresidetains);

				    StringTokenizer modelcoordstoks = new StringTokenizer(modelcoords, " ");

				    String modxcoords = modelcoordstoks.nextToken();
				    float ModXcoords = (new Float(modxcoords)).floatValue();
				    String modycoords = modelcoordstoks.nextToken();
				    float ModYcoords = (new Float(modycoords)).floatValue();
				    String modzcoords = modelcoordstoks.nextToken();
				    float ModZcoords = (new Float(modzcoords)).floatValue();
									
				
				    // get the details of the hetatom including the coords 
				    String hetatmdetails = (String)enumer3.nextElement();
				    StringTokenizer hetatmtoks = new StringTokenizer(hetatmdetails, " ");
				    String HetatmResiNumb = hetatmtoks.nextToken();
				    String HetatmResiType = hetatmtoks.nextToken();
				    String Hetatmcoords = (String)hetatmcoordscoordshash.get(hetatmdetails);
				    StringTokenizer Hetatmcoordstoks = new StringTokenizer(Hetatmcoords, " ");
				    String hetatmxcoords = Hetatmcoordstoks.nextToken();
				    float HetatmXcoords = (new Float(hetatmxcoords)).floatValue();
				    String hetatmycoords = Hetatmcoordstoks.nextToken();
				    float HetatmYcoords = (new Float(hetatmycoords)).floatValue();
				    String hetatmzcoords = Hetatmcoordstoks.nextToken();
				    float HetatmZcoords = (new Float(hetatmzcoords)).floatValue();
				    String hetatom = Hetatmcoordstoks.nextToken().toUpperCase();

				    //calculate the distance between residues in the modela and the temp	
									
				    double modeldistance = Math.sqrt( ((ModXcoords-HetatmXcoords)*(ModXcoords-HetatmXcoords)) + ((ModYcoords-HetatmYcoords)*(ModYcoords-HetatmYcoords)) + ((ModZcoords-HetatmZcoords)*(ModZcoords-HetatmZcoords)) );
				    double modelSi = 1/(1+((modeldistance/d)*(modeldistance/d)));
									

				    //System.out.println("Model resi number hetatom resi number and model Si " + modelResiNum1 + " " + HetatmResiNumb + " " +modelSi ); 
									
				    if( modelSi > maxmodelSi )
				    {
					maxmodelSi = modelSi;
					minmodelDist = modeldistance;
					//find the closest equivalent residue of the template to the model
					closestmodel_res = modelResiNum1;	
					closestmodel_restype = modelResiType1;

					closestlig_res = HetatmResiNumb;
					closestlig_restype = HetatmResiType;

					String Inputinfo = closestmodel_res + " " + closestmodel_restype + " " + closestlig_restype;
					
					siHash.put(Inputinfo , maxmodelSi );
	
	
				    }
	
				}
							
			    }
					    
			}
		     
			int numbcount = 0;

			Hashtable scoringHash = new Hashtable();
			
			for( Enumeration enumerX = siHash.keys(); enumerX.hasMoreElements(); )
			{
			    String Details = (String)enumerX.nextElement();
			    StringTokenizer detailstoks = new StringTokenizer(Details, " ");
			    String residueNumb = detailstoks.nextToken();
			    String residueType = detailstoks.nextToken();
			    String ligand = detailstoks.nextToken();
			    Double siScore = (Double)siHash.get(Details);
			    numbcount++;
			    StringBuffer ligbuff = new StringBuffer();

			    CAMEOligCategoryVariation cameolcv = new CAMEOligCategoryVariation( FunFOLD_outputfile );

			    HashSet metalLigsSet = (HashSet)cameolcv.getmetalLigsSet();
			    HashSet DNALigsSet= (HashSet)cameolcv.getDNALigsSet();
			    HashSet organicLigsSet = (HashSet)cameolcv.getorganicLigsSet();
			    HashSet peptideLigsSet = (HashSet)cameolcv.getpeptideLigsSet();
			    //StringBuffer  OutputBuff = (StringBuffer)clcv.getOutputBuff();

			    String ligandType = "";

			    if(metalLigsSet.contains(ligand))
			    {
				ligandType = "I";
			    }

			    if(DNALigsSet.contains(ligand))
			    {
				ligandType = "N";
			    }


			    if(organicLigsSet.contains(ligand))
			    {
				ligandType = "O";
			    }


			    if(peptideLigsSet.contains(ligand))
			    {
				ligandType = "P";
			    }


			    if((ligandType.equals("I")) || (ligandType.equals("N")) || (ligandType.equals("O")) || (ligandType.equals("P")))
			    {

				    //String resiinfo = "r="+residueNumb + "; n=" + residueType +"; |";
				    String resiinfo = "r="+ residueType + "; n=" + residueNumb +"; |";
				    ligbuff.append(ligandType + "=" + df.format(siScore));

				    if( scoringHash.containsKey( resiinfo ) )
				    {
					  String liginfo = (String)scoringHash.get(resiinfo);
					  StringTokenizer ligtoks = new StringTokenizer(liginfo, "=; " );
					  
					  while(ligtoks.hasMoreTokens())
					  {
						String type = ligtoks.nextToken();
						String SCORE = ligtoks.nextToken();
						Double score = (new Double(SCORE)).doubleValue();
						
						if(type.equals(ligandType))
						{
						  
							if( siScore > score )
							{
							    liginfo = ligandType + "=" + df.format(siScore) + ";" ;
							    scoringHash.put( resiinfo , liginfo );

							}

							if( siScore <= score )
							{
							    liginfo =  type+ "=" + df.format(score) + ";";
							    scoringHash.put( resiinfo , liginfo );

							}

						}

						
						
						else if(!type.equals(ligandType))
						{
						      liginfo = liginfo + "; " + ligandType + "=" + df.format(siScore) + ";";
						      scoringHash.put( resiinfo , liginfo.replaceAll(";;", ";") );
						}

					  }
	    
				    }
							  
				    else if( !scoringHash.containsKey(  resiinfo ) )
				    {
					scoringHash.put( resiinfo ,  ligbuff.toString() );
				    }
				}

			}

			Hashtable newligandinfohash = new Hashtable();
			Vector newligandinfovect = new Vector();
		
			for( Enumeration enumerY = scoringHash.keys(); enumerY.hasMoreElements(); )
			{
			    
			    String ResiInfo = (String)enumerY.nextElement();
			    //System.out.println("ResiInfo "+ ResiInfo);
			    StringTokenizer resitoks = new StringTokenizer(ResiInfo, ";|");
			    String residuenumb = resitoks.nextToken();
			    String residuetype = resitoks.nextToken();
			    String scoringinfo = (String)scoringHash.get(ResiInfo);

			    	    
			    
			    if(!scoringinfo.contains("I"))
			    {
				scoringinfo = scoringinfo + "  I=000;";
			    }

			    if(!scoringinfo.contains("N"))
			    {
				scoringinfo = scoringinfo + "  N=000;";
			    }


			    if(!scoringinfo.contains("O"))
			    {
				scoringinfo = scoringinfo + "  O=000;";
			    }


			    if(!scoringinfo.contains("P"))
			    {
				scoringinfo = scoringinfo + "  P=000;";
			    }

			    outputresults.append( ResiInfo + " " );

			    StringTokenizer infotoks = new StringTokenizer(scoringinfo, "; ");
			    String I = "";
			    String O = "";
			    String N = "";
			    String P = "";

  
			    while(infotoks.hasMoreTokens())
			    {
				String BIO = infotoks.nextToken();

				if(BIO.startsWith("I"))
				{
			    
				    I = BIO;

				}

				if(BIO.startsWith("O"))
				{
			    
				    O = BIO;				   

				}

				if(BIO.startsWith("N"))
				{
			    
				    N = BIO;

				}


				if(BIO.startsWith("P"))
				{
			    
				    
				    P = BIO;
				}
								
			    }

			    outputresults.append( I+ "; " + O+ "; " +  N+ "; " + P+ "; " );
			    outputresults.append( "|" + "\n");

			    LigResults = outputresults.toString();
			}	    
			
		}

		catch( Exception e )
		{
			System.out.println( "Error ! CAMEOScoringCode" + e );
		}	
	}

        public StringBuffer getoutputresults()
	{
		return outputresults;
	}
    

	public static void main( String args[])
	{
		CAMEOScoringCode csc = new CAMEOScoringCode( args[0], args[1], args [2], args[3] );
		StringBuffer outputresults  = (StringBuffer)csc.getoutputresults();
		System.out.println(outputresults.toString());
	
	}
}
			