//package neural;
import java.io.*;
import java.util.*;

public class BackpropagationNet2 extends NeuralNet {

    Vector neuronLayerVector;
    NeuronLayer neuronLayerArray[];
    WeightMatrix weightMatrixArray[];
    Pattern inputPatternArray[];
    Pattern targetPatternArray[];
    String outputPatternArray[];
    double minimumError;
    double error;
    double accuracy;
    float layerOutputError[][];
    String conversionTable[][];
    int lastLayer;
    int lastMatrix;
    int lastPattern;
    int multiplier;

    //System.out.println("Starting BPN");

    public void setweights( WeightMatrix weights[] )
    {
        for(int j = 0; j < weights.length; j++)
        {
                WeightMatrix wm = weights[j];
                weightMatrixArray[j] = wm;

	      
        }
    }

    public BackpropagationNet2() {
        learningCycle = 0;
        maxLearningCycles = -1;
        minimumError = 0.00050000000000000001D;
        learningRate = 0.25D;
        error = 1000D;
        multiplier = 0;
        accuracy = 0.20000000000000001D;
        neuronLayerVector = new Vector();
        stopLearning = false;
        resetTime();
    }

    public void addNeuronLayer(int i) {
        neuronLayerVector.addElement(new NeuronLayer(i * multiplier));
    }

    public void connectLayers() {
        weightMatrixArray = new WeightMatrix[neuronLayerVector.size() - 1];
        neuronLayerArray = new NeuronLayer[neuronLayerVector.size()];
        int i = 0;
        for(Enumeration enumeration = neuronLayerVector.elements(); enumeration.hasMoreElements();)
            neuronLayerArray[i++] = (NeuronLayer)enumeration.nextElement();

        //neuronLayerVector = null;
        for(int j = 0; j < weightMatrixArray.length; j++) {
            weightMatrixArray[j] = new WeightMatrix(neuronLayerArray[j].size(), neuronLayerArray[j + 1].size(), true);
            weightMatrixArray[j].init();
        }

        lastLayer = neuronLayerArray.length - 1;
        lastMatrix = weightMatrixArray.length - 1;
    }

    public void setMinimumError(double d) {
        minimumError = d;
    }

    public double getMinimumError() {
        return minimumError;
    }

    public void setAccuracy(double d) {
        accuracy = d;
    }

    public double getAccuracy() {
        return accuracy;
    }

    public float[][] getWeightValues(int i) {
        return weightMatrixArray[i].getWeights();
    }

    public float[] getNeuronOutputs(int i) {
        return neuronLayerArray[i].getOutput();
    }

    public int getNumberOfLayers() {
        return neuronLayerArray.length;
    }

    public int getNumberOfNeurons(int i) {
        return neuronLayerArray[i].size();
    }

    public int getNumberOfWeights() {
        int i = 0;
        for(int j = 0; j <= lastMatrix; j++)
            i += weightMatrixArray[j].size();

        return i;
    }

    public int getNumberOfWeights(int i) {
        return weightMatrixArray[i].size();
    }

    public int getNumberOfPatterns() {
        return inputPatternArray.length;
    }

    public String getInputPattern(int i) {
        return inputPatternArray[i].getPatternString();
    }

    public String getTargetPattern(int i) {
        return targetPatternArray[i].getPatternString();
    }

    public float getOutputPattern(int i) {

        float f = 0.0F;
        for(int j = 0; j < layerOutputError[0].length; j++)
            f = targetPatternArray[i].getValue(j) - layerOutputError[i][j];


        return f;
    }

    public float getPatternError(int i) {
        float f = 0.0F;
        for(int j = 0; j < layerOutputError[0].length; j++)
            f += Math.abs(layerOutputError[i][j]);

        return f;
    }

    public double getError() {
        return error;
    }

    public void learn() {
        if(error > minimumError && (learningCycle < maxLearningCycles || maxLearningCycles == -1)) {
            learningCycle++;
            for(int i = 0; i <= lastPattern; i++) {
                neuronLayerArray[0].setInput(inputPatternArray[i]); //input values to neurons
                for(int j = 1; j <= lastLayer; j++) {
                    neuronLayerArray[j].computeInput(neuronLayerArray[j - 1], weightMatrixArray[j - 1]);//get output from last layer
                    neuronLayerArray[j].computeOutput(); //activate sigmoid function
                }
                //System.out.println( lastLayer );
                neuronLayerArray[lastLayer].computeLayerError(targetPatternArray[i]); //compare output with target
                layerOutputError[i] = neuronLayerArray[lastLayer].getLayerError();

                for(int k = lastMatrix; k >= 0; k--)
                {
                    weightMatrixArray[k].changeWeights(neuronLayerArray[k].getOutput(), neuronLayerArray[k + 1].getLayerError(), learningRate);
                    if(k > 0)
                        neuronLayerArray[k].computeLayerError(neuronLayerArray[k + 1], weightMatrixArray[k]);
                }

            }

            double d = 0.0D;
            for(int l = 0; l < layerOutputError.length; l++) {
                for(int i1 = 0; i1 < layerOutputError[0].length; i1++)
                    d += square(layerOutputError[l][i1]);

            }

            error = Math.abs(d * 0.5D);
				//System.out.println( error );
            return;
        } else {
            stopLearning = true;
            return;
        }
    }

    public String recall(String s) {
        Pattern pattern = new Pattern(s);
        float af[] = new float[targetPatternArray[0].size()];
        neuronLayerArray[0].setInput(pattern);
        for(int i = 1; i <= lastLayer; i++) {
            neuronLayerArray[i].computeInput(neuronLayerArray[i - 1], weightMatrixArray[i - 1]);
            neuronLayerArray[i].computeOutput();
        }

        af = neuronLayerArray[lastLayer].getOutput();
        //float s1 = 0;
	String s1 = "";

        //for(int j = 0; j < af.length; j++)
            //s2 = s2 + ((double)af[j] < accuracy ? "0" : "1");
				//System.out.println( (double)af[j] );
		for(int j = 0; j < af.length; j++)
		{	
		  s1 = s1 + " " + String.valueOf(af[j]);
		  //s1 =  (float)( (double)af[j] );
		}
        //for(int k = 0; k < s2.length(); k += multiplier)
            //s1 = s1 + getAsciiValue(s2.substring(k, k + multiplier));

        return s1;
    }

    public synchronized void readConversionFile(String s) {
        Object obj = null;
        try {
	    InputStream is = BackpropagationNet2.class.getResourceAsStream("/" + s );
            DataInputStream datainputstream = new DataInputStream( is );
            int i = Integer.parseInt(datainputstream.readLine());
            conversionTable = new String[i][2];
            for(int j = 0; j < i; j++) {
                String s1 = datainputstream.readLine();
                conversionTable[j][0] = String.valueOf(s1.charAt(0));
                conversionTable[j][1] = s1.substring(1);
            }
	    datainputstream.close();
            multiplier = conversionTable[0][1].length();
            return;
        }
        catch(FileNotFoundException filenotfoundexception) {
            error(105);
            return;
        }
        catch(IOException ioexception) {
            error(104);
        }
    }

    //String getAsciiValue(String s) {
    //    int i = 0;
    //    int j = conversionTable.length;
    //    boolean flag = false;
    //    boolean flag1 = false;
    //    while(i < j)  {
    //        int k = i + j >> 1;
    //        int l = s.compareTo(conversionTable[k][1]);
    //        if(l == 0)
    //            return conversionTable[k][0];
    //        if(l > 0)
    //            i = k;
    //        else
    //            j = k;
    //    }
    //    return "*";
    //}

    public synchronized void readPatternFile(String s) {
        //Object obj = null;
        //System.out.println("Reading pattern file..." );
        try {
                DataInputStream datainputstream = new DataInputStream(new FileInputStream(s));
                //System.out.println(datainputstream);

                int i = Integer.parseInt(datainputstream.readLine()); //number of neuron patterns
                int j = Integer.parseInt(datainputstream.readLine()); //number of input neurons
                int k = Integer.parseInt(datainputstream.readLine()); //number of output/target neurons

                //System.out.println(i);

                inputPatternArray = new Pattern[i];
                targetPatternArray = new Pattern[i];
                outputPatternArray = new String[i];
                lastPattern = inputPatternArray.length - 1;
                layerOutputError = new float[lastPattern + 1][neuronLayerArray[lastLayer].size()];

               for( int l = 0; l< i ; l++ )
               {
                String s1 = datainputstream.readLine();

                StringBuffer patstr = new StringBuffer();
                StringBuffer targetstr = new StringBuffer();
                int t = 0;
                String next;

                StringTokenizer st = new StringTokenizer( s1 );

                //first two tokens are filename1 and filename2
                st.nextToken();
                st.nextToken();

                while (st.hasMoreTokens())
                {

                  next = st.nextToken();
                  t ++;
                  if( t <= j )
                    patstr.append( next + " " );
                  else if( t > j && t <= j+k )
                    targetstr.append( next + " " );


                }

                //System.out.println( "pat: "+ patstr );
                //System.out.println( "target: " + targetstr.toString() );


                inputPatternArray[l] = new Pattern( patstr.toString() );
                targetPatternArray[l] = new Pattern( targetstr.toString() );
                outputPatternArray[l] = new String();

              }

              //System.out.println("Pattern file read..." );
	      datainputstream.close();
        }
        catch(IOException e) {
            System.out.println( "Pattern file could not be read...\n" + e );

        }
    }

        public void save( String filename )
	{
                File savefile = new File( filename );

		try
		{
			FileOutputStream fos = new FileOutputStream(savefile);
			//GZIPOutputStream gzos = new GZIPOutputStream(fos);
			ObjectOutputStream out = new ObjectOutputStream(fos);

                        WeightMatrix weights[];
                        weights = new WeightMatrix[neuronLayerVector.size() - 1];

                        for(int j = 0; j < weightMatrixArray.length; j++)
                        {
                                WeightMatrix wm = weightMatrixArray[j];
                                weights[j] = wm;
                        }

                        out.writeObject( weights );
			out.flush();
			out.close();
			//System.out.println( "File saved.");

		}

		catch (IOException e)
		{
			System.out.println(e);
		}
	}

        public void load( String filename )
        {
               //File loadfile = new File( filename );
		

		//if( loadfile.exists() )
		//{
			try
			{
				InputStream is = BackpropagationNet2.class.getResourceAsStream("/" + filename );
				//FileInputStream fis = new FileInputStream(loadfile);
				ObjectInputStream in = new ObjectInputStream(is);
				WeightMatrix weights[];
                                weights = (WeightMatrix[])in.readObject();
                                //System.out.println( loadhash );
				in.close();
				setweights( weights );
                                //System.out.println( "Weights loaded and set." );
			}

			catch (Exception e)
			{
				System.out.println(e);
			}
		//}

                //else
                //  System.out.println( loadfile + " could not be found" );

	}
}
