#!/bin/bash
export LC_ALL=en_US.utf-8
export BIOLIP_Directory=/home/roche/bin/test/FunFOLD3/BioLip/
export Home_Directory=/home/roche/bin/FunFOLD3/FunFOLD3/JARCode/

cd $BIOLIP_Directory

echo "getting old receptor library"
wget http://zhanglab.ccmb.med.umich.edu/BioLiP/download/receptor_2013-03-6.tar.bz2

echo "getting old ligand library"
wget http://zhanglab.ccmb.med.umich.edu/BioLiP/download/ligand_2013-03-6.tar.bz2

echo "getting old txt library"
wget http://zhanglab.ccmb.med.umich.edu/BioLiP/download/BioLiP.tar.bz2

echo "unzipping libraries"
bunzip2 receptor_2013-03-6.tar.bz2  
bunzip2 BioLiP.tar.bz2
bunzip2 ligand_2013-03-6.tar.bz2

tar xf ligand_2013-03-6.tar
tar xf receptor_2013-03-6.tar
tar xf BioLiP.tar

echo "updating libraries"

cd $Home_Directory

perl download_all_sets_V2.pl $BIOLIP_Directory

cd $BIOLIP_Directory

cat BioLiP*.txt > NewBioLip.txt

mv NewBioLip.txt BioLiP.txt

rm *.tar.bz2


echo "downloading and updating CIF library"
wget ftp://ftp.wwpdb.org/pub/pdb/data/monomers/components.cif

cp components.cif components.cif.old

wget ftp://ftp.wwpdb.org/pub/pdb/data/monomers/components.cif
oldsize=$(du -b components.cif | cut -f 1)
newsize=$(du -b components.cif.1 | cut -f 1)
if [ $newsize -gt $oldsize ]; then
mv components.cif.1 components.cif
else
rm components.cif.1
echo deleted file - new file size is not greater than the old file size
fi



