import java.io.*;
import java.util.*;
import java.lang.Math.*;


public class bindingSiteDistanceTest
{
	double BDT = 0.0;
	double MCC = 0.0;
	StringBuffer verbosebuf = new StringBuffer();
	
	public bindingSiteDistanceTest( String res_num_pred, String res_num_obs, String pdbfile, String d_value )
	{
		try
		{
			StringTokenizer predtoks = new StringTokenizer( res_num_pred, " ," );
			StringTokenizer obstoks = new StringTokenizer( res_num_obs, " ," );
			HashSet predSet = new HashSet();
			HashSet obsSet = new HashSet();
			while( predtoks.hasMoreTokens() )
				predSet.add(predtoks.nextToken());
			while( obstoks.hasMoreTokens() )
				obsSet.add(obstoks.nextToken());
			
			//get xyz coordinates of CA for predicted residues and real residues
			Hashtable predHash = new Hashtable();
			Hashtable obsHash = new Hashtable();
			BufferedReader inpdb = new BufferedReader( new FileReader( pdbfile ) );
			String line = inpdb.readLine();
			int res_length_of_PDB = 0;
			do
			{
				if( line.startsWith("ATOM") )
				{
					String atomtype = line.substring(12, 17).trim();
					String resnumstr = line.substring(22, 26).trim();
					
					if( atomtype.equals( "CA" ) )
					{
						String atominf = line.substring( 0, 26 );
						String xstr = line.substring(30,38).trim();
						String ystr = line.substring(38,46).trim();
						String zstr = line.substring(47,54).trim();
						xyzCoords xyz = new xyzCoords( atominf, xstr, ystr, zstr );
						
						//System.out.println( atominf );
						if( predSet.contains( resnumstr ) )
							predHash.put( resnumstr, xyz );
							
						if( obsSet.contains( resnumstr ) )
							obsHash.put( resnumstr, xyz );
						
						res_length_of_PDB++;
					} 
				}
				line = inpdb.readLine();
			}
			while(  line != null && !line.startsWith("TER") );
			
			//System.out.println( predHash + "\n" + obsHash );
			
			//for MCC calcuation
			int TP = 0; 
			int FP = 0;
			int TN = 0;
			int FN = 0;
			
			//calc Si of all distances and get maxSi for each residue then get sum of maxSi
			float d = (new Float( d_value ) ).floatValue(); //distance cutoff for Si score
			double totMaxSi = 0.0;
			for( Enumeration enumer = predHash.keys(); enumer.hasMoreElements(); )
			{
				String resnumstr = (String)enumer.nextElement();
				xyzCoords xyz1 = (xyzCoords)predHash.get( resnumstr );
				double maxSi = 0.0;
				double minDist = 0.0;
				String closest_res = "";
				
				if ( obsHash.containsKey(resnumstr))
				{
					TP++;
				}
				
				if ( !obsHash.containsKey(resnumstr))
				{
					FP++;
				}
			      
				for( Enumeration enumer2 = obsHash.keys(); enumer2.hasMoreElements(); )
				{
					String resnumstr2 = (String)enumer2.nextElement();
					xyzCoords xyz2 = (xyzCoords)obsHash.get( resnumstr2 );
					
					float x1 = xyz1.getX();
					float y1 = xyz1.getY();
					float z1 = xyz1.getZ();
					float x2 = xyz2.getX();
					float y2 = xyz2.getY();
					float z2 = xyz2.getZ();
					
					//calculate Euclidean distance between residues
					double distance = Math.sqrt( ((x1-x2)*(x1-x2)) + ((y1-y2)*(y1-y2)) + ((z1-z2)*(z1-z2)) );

					//si score
					double Si = 1/(1+((distance/d)*(distance/d)));
					//System.out.println( resnumstr + " " + resnumstr2 + ": " + Si);
					
					if( Si > maxSi )
					{
						maxSi = Si;
						minDist = distance;
						closest_res = resnumstr2;
					}
				}
				
				//System.out.println( resnumstr + " is closest to " + closest_res + " at " + minDist + " Angstroms (Si=" + maxSi + ")" );
				
				//calculate sum of maxSi vect
				totMaxSi = totMaxSi+maxSi;
			}			
			//verbosebuf.append("Sum of maxSi = " + totMaxSi +"\n" ); 
			
			//normalise by max npred, nobs
			float norm = Math.max( predHash.size(), obsHash.size() );
			//verbosebuf.append("Normalisation = " + norm +"\n" );
			
			//calc final BDT
			BDT = totMaxSi/norm;
			//verbosebuf.append( "Binding site distance test (BDT) score = " + BDT +"\n" );
			
			
			//also count FN and work out TN for MCC calculation
			for( Enumeration enumer2 = obsHash.keys(); enumer2.hasMoreElements(); )
			{	
				String resnumstr2 = (String)enumer2.nextElement();
				
				if ( !predHash.containsKey(resnumstr2))
				{
					FN++;
				}
			}
			
			TN = res_length_of_PDB-TP-FN-FP;
			
			int above = (TP*TN-FP*FN);
			int below = ((TP+FP)*(TP+FN)*(TN+FP)*(TN+FN));
			double ABOVE = (new Integer(above)).doubleValue();
			double BELOW = (new Integer(below)).doubleValue();
			double SQRT_BELOW = Math.sqrt(BELOW);
			
			MCC = ABOVE/SQRT_BELOW;
			
			verbosebuf.append( "TP=" + TP + " FP="+FP + " TN="+ TN +  " FN="+ FN + "\nMatthews Correlation Coefficient (MCC) = " + MCC +"\n" );
			verbosebuf.append("Sum of maxSi = " + totMaxSi +"\n" );
			verbosebuf.append("Normalisation = " + norm +"\n" );
			verbosebuf.append( "Binding-site Distance Test (BDT) score = " + BDT );
		}
					
		catch (Exception e)
		{
			System.out.println( "Error running BDT score -- " + e.toString() );
		}
		
	}
	
	public double getBDT()
	{
		return BDT;
	}
	
	public double getMCC()
	{
		return MCC;
	}
	
	public String getVerboseOutput()
	{
		return verbosebuf.toString();
	}
	
	public static void main( String args[] )
	{
		if( args.length != 4 )
		{
			System.out.println( "Usage:\n\nBDT.sh <predicted residue numbers> <observed residue numbers> <PDB file> <distance treshold>\n\nOr:\n\njava -jar BDT.jar <predicted residue numbers> <observed residue numbers> <PDB file> <distance treshold>\n" );

		}
		else
		{
			bindingSiteDistanceTest BDT = new bindingSiteDistanceTest(args[0], args[1], args[2], args[3]);
			System.out.println( BDT.getVerboseOutput() );
		}
	}
	
}
